//==============================================================================
//
// $File: //depot/indesign_5.0/gm/build/scripts/XHTML for Digital Editions/startup scripts/OEBExportMenuItemLoader.jsx $
//
// Owner: Paul Norton
//
// $Author: sstudley $
//
// $DateTime: 2007/02/15 13:37:33 $
//
// $Revision: #1 $
//
// $Change: 505969 $
//
// Copyright 2006 Adobe Systems Incorporated. All rights reserved.
//
// Purpose: Export InDesign documents to epub files for Digital Editions
//
// binary scripts cannot use the #targetengine directive.
// #targetengine is required so that the menu item will work (can't let the script unload.)
// so this script isn't binary, the rest of the plug-in will be.
//
//==============================================================================

#targetengine "digital editions"

function DEExport() {
	
}


//------------------------------------------------------------------------------
// Squeeze.getScriptsFolderPath
//------------------------------------------------------------------------------

DEExport.getScriptsFolderPath = function() {
	try {
		var script = app.activeScript;
	} catch(e) {
		// we are running from the ESTK
		var script = File(e.fileName);
	}
	return script.path + '/../';
} // DEExport.getScriptsFolderPath

//------------------------------------------------------------------------------
// DEExport.loadScript
//------------------------------------------------------------------------------

DEExport.loadScript = function(filename) {
	var file = File(DEExport.getScriptsFolderPath() + filename );
	var	script = undefined;
	if (file.exists) {
		file.open();
		script = file.read();
		file.close();
	}
	// we return the script rather than calling eval() right here
	// because the results of eval() are only valid within the
	// scope of the function that calls eval()
	return script;
} //DEExport.loadScript

DEExport.script = DEExport.loadScript("OEBExportMenuItem.jsxbin");
if(DEExport.script != undefined) {
	eval(DEExport.script);
}